EvaluateScript("bchange.js");

var blood_layer = 4;
var back_blood_layer = 3;

var max_blood = 100;

var gore_score = 0;
var gore_multi = 1;
var gore_counter = 0;
var gore_max = 300;
var gore_level = 0;
var gore_next = 5;

var blood = new Array(max_blood);
for (i=0;i<max_blood;i++)
{
	blood[i] = new Object();
	blood[i].x = -100;
	blood[i].y = 0;

	blood[i].type = 0;
	blood[i].frame = 0;
	blood[i].dir = 0;
	blood[i].id1 = 0;
}

var max_spark = 10;
var spark = new Array(max_spark);

for (i=0;i<max_spark;i++)
{
	spark[i] = new Object();
	spark[i].x = -100;
	spark[i].y = 0;

	spark[i].type = 0;
	spark[i].frame = 0;
	spark[i].dir = 0;
	spark[i].id1 = 0;
}


var blood_dx = -100;
var blood_dy = 0;
var max_trails = 50;
var b_slowx = 0.5;
var b_slowy = 1;
var b_rate = 12;
var btrails = new Array();
for (i=0;i<max_trails;i++)
{
  btrails[i] = new Object();
  btrails[i].x = 0;
  btrails[i].y = 0;
  btrails[i].vx = 0;
  btrails[i].vy = 0;
  btrails[i].size = 0;
}


var max_guts = 1;
var gut_layer = 4;
var guts = new Array();
var min_guts = 0;
for (i=0;i<max_guts;i++)
{
	guts[i] = new Object();
	guts[i].x = blood_dx;
	guts[i].y = 0;

	guts[i].vx = 0;
	guts[i].vy = 0;
	guts[i].name = "";

	guts[i].id1 = 0;
	guts[i].frame = 0;
	guts[i].direction = "enemy1_guts1";
	guts[i].flamed = 0;
	guts[i].blood = 1;
	guts[i].layer = gut_layer;
}

var heads = new Array();
var head_layer = 4;
var max_heads;
var max_headvx = 4;
var max_headvy = 6;

function SetupHeads()
{
	max_heads = max_entities;
	
	for (cci=0;cci<max_heads;cci++)
	{
		heads[cci] = new Object();
		heads[cci].x = blood_dx;
		heads[cci].y = 0;
	
		heads[cci].vx = 0;
		heads[cci].vy = 0;
		heads[cci].rotation = 0;
		heads[cci].name = "";
	
		heads[cci].id1 = 0;
		heads[cci].frame = 0;
		heads[cci].direction = "enemy1";
		heads[cci].flamed = 0;
		heads[cci].active = false;
		heads[cci].stop = false;
	}
}




function UpdateHeads()
{
  var sx, sy;
  var gravity_const = 0.5;
  var max_fall = 7;
  var speed = 10;
  var friction = 0.15;
	var hbounce = 0.5;
  var gx,gy;

	for (i=0;i<max_heads;i++)
	{
		if (heads[i].x != blood_dx && heads[i].name != "" && heads[i].active == true && heads[i].stop == false)
	  {
	    SetPersonIDLayer(heads[i].id1, 0);
			if (heads[i].vy < max_fall && !IsPersonIDObstructed(heads[i].id1, heads[i].x, heads[i].y+1))
				heads[i].vy+=gravity_const;
			
			
			if (IsXYInWater(heads[i].x,heads[i].y))
			{
				if (heads[i].vy > 1)
					heads[i].vy-=1;
				if (heads[i].vy <-1)
					heads[i].vy+=1;
				if (heads[i].vx > 1)
					heads[i].vx-=1;
				if (heads[i].vx <-1)
					heads[i].vx+=1;
			}
			
			heads[i].x+=heads[i].vx;
			heads[i].y+=heads[i].vy;
			
			if (g_boss_active == 1)
			{
				if (heads[i].x > 70*16+128*16)
				{
					heads[i].x = 70*16+128*16;
					heads[i].vx*=-1;
				}
			}
			
			gx=heads[i].x;
			gy=heads[i].y;
			
			if (IsPersonIDObstructed(heads[i].id1, heads[i].x, heads[i].y))
			{
				for (j=0;j<speed;j++)
				{
					heads[i].x -=heads[i].vx/speed;
					heads[i].y -=heads[i].vy/speed;
					if (!IsPersonIDObstructed(heads[i].id1, heads[i].x, heads[i].y))
						break;
				}


				sx = heads[i].vx;
				sy = heads[i].vy;


				if (IsPersonIDObstructed(heads[i].id1, heads[i].x, heads[i].y+1))
				  heads[i].vy*=-hbounce;
				if (IsPersonIDObstructed(heads[i].id1, heads[i].x+1, heads[i].y))
				  heads[i].vx*=-hbounce;


				if (IsPersonIDObstructed(heads[i].id1, heads[i].x, heads[i].y-1))
				  heads[i].vy*=-hbounce;
				if (IsPersonIDObstructed(heads[i].id1, heads[i].x-1, heads[i].y))
				  heads[i].vx*=-hbounce;
				  
				if (sx != heads[i].vx)
				{
				  if (sx > 0)
						MarkBlood(heads[i].x+6,gy);
					else
						MarkBlood(heads[i].x-6,gy);
						
					if (Math.abs(sx) > 2)
						PlaySound(36);
						

//					BloodStain(heads[i].x, heads[i].y, sx, sy, "x");
/*
				  var tempyy = Math.abs(sx);
				  if (tempyy > 5)
				    tempyy = 5;
					PlaySound(1,255*tempyy/5, 0.25);
*/					
				}
				if (sy != heads[i].vy)
				{
				  if (sy > 0)
						MarkBlood(gx,heads[i].y+6);
					else
						MarkBlood(gx,heads[i].y-6);

					if (Math.abs(sy) > 2)
						PlaySound(36);

//					BloodStain(limbs[i].x, limbs[i].y, sx, sy, "y");
/*
				  var tempyy = Math.abs(sy);
				  if (tempyy > 5)
				    tempyy = 5;
					PlaySound(1,255*tempyy/5, 0.25);
*/
				}
				
				if (sx== heads[i].vx && sy == heads[i].vy)
				{
				  heads[i].vx*=-0.8;
				}
	
				if (Math.abs(heads[i].vy)<1.5)
					heads[i].vy = 0;

			}
		
			if (heads[i].vx < 0 && IsHeadOnGround(i))
			{
				heads[i].vx+=friction/4;
				if (heads[i].vx > 0)
					heads[i].vx = 0;
			}
			else if (heads[i].vx > 0 && IsHeadOnGround(i))
			{
				heads[i].vx-=friction/4;
				if (heads[i].vx < 0)
					heads[i].vx = 0;
			}
			
			if (IsHeadOnGround(i) && heads[i].vx == 0)
			{
				heads[i].stop = true;
			}

			heads[i].rotation+=heads[i].vx*0.04;

			SetPersonIDX(heads[i].id1, heads[i].x);
			if (g_current_level == 9)
				SetPersonIDY(heads[i].id1, heads[i].y+2-8);
			else
				SetPersonIDY(heads[i].id1, heads[i].y+2);
			SetPersonIDAngle(heads[i].id1, heads[i].rotation);
      if (Math.abs(heads[i].vx)+Math.abs(heads[i].vy) > 0.5&& g_frames%b_rate == i%b_rate)
				SpawnBlood(heads[i].x,heads[i].y,heads[i].vx*b_slowx,heads[i].vy*b_slowy,3, "w", undefined, true);
//				SpawnBlood(gut.x,gut.y,gut.vx*b_slowx,gut.vy*b_slowy,3, "w");

			if (heads[i].x > GetLayerWidth(heads[i].layer)*GetTileWidth()+GetTileWidth()  ||
				  heads[i].x < -GetTileWidth() ||
				  heads[i].y > GetLayerHeight(heads[i].layer)*GetTileHeight()+GetTileHeight())
			{
			  heads[i].name = "";
			  heads[i].x = blood_dx;
			}
    SetPersonIDLayer(heads[i].id1, heads[i].layer);


			if (Math.abs(entities[0].x-heads[i].x) > 2*active_w || Math.abs(entities[0].y-heads[i].y) > 2*active_h)
			{
				heads[i].active = false;
			}
		}
		else if (Math.abs(entities[0].x-heads[i].x) < 2*active_w && Math.abs(entities[0].y-heads[i].y) < 2*active_h)
		{
			heads[i].active = true;
		}
	}
}

function IsHeadOnGround(num)
{
	if (IsPersonIDObstructed(heads[num].id1, heads[num].x, heads[num].y+1) && Math.abs(heads[num].vy) < 1.5)
		return true;
	return false;
}










function UpdateBlood()
{
	UpdateDrips();
	
	for (i=0;i<max_blood;i++)
	{
		if (blood[i].x > 0)
		{
			if (blood[i].type == 1)
			{
				if (g_frames%frameupdate == 0)
				  blood[i].frame++;
				  
				SetPersonIDX(blood[i].id1, blood[i].x);
				SetPersonIDY(blood[i].id1, blood[i].y);
				
				SetPersonIDFrame(blood[i].id1, blood[i].frame);
				SetPersonIDDirection(blood[i].id1, "hit1");
				
				if (GetPersonIDFrame(blood[i].id1) == 0)
				{
					blood[i].x = -100;
				}
			}
		}
	}
	UpdateSparks();
	UpdateTrails();
	UpdateGuts();
	UpdateHeads();
}

function UpdateSparks()
{
	for (i=0;i<max_spark;i++)
	{
		if (spark[i].x > 0)
		{
			if (spark[i].type == 1)
			{
				if (g_frames%frameupdate == 0)
				  spark[i].frame++;
				  
				SetPersonIDX(spark[i].id1, spark[i].x);
				SetPersonIDY(spark[i].id1, spark[i].y);

				SetPersonIDFrame(spark[i].id1, spark[i].frame);

				if (spark[sb].dir!=undefined)
					SetPersonIDDirection(spark[i].id1, spark[i].dir);
			else
					SetPersonIDDirection(spark[i].id1, "hit1");

//				MarkBlood(spark[i].x+2,spark[i].y-2);

				
				if (GetPersonIDFrame(spark[i].id1) == 0)
				{
					spark[i].x = -100;
				}
			}
		}
	}
}

function SpawnBloodSplat(x,y, vx, vy, damage)
{
  var sx,sy,length;
  var sconst = 2;
	for (sb = 0;sb<max_blood;sb++)
	{
		if (blood[sb].x == -100)
		{
			blood[sb].x = x;
			blood[sb].y = y;
			
			blood[sb].type = 1;
			blood[sb].dir = "hit1";
			blood[sb].frame = 1;

			if (g_supernaut_active > 0)
				SetPersonIDLayer(blood[sb].id1, g_supernaut_head_layer+1);
			else
				SetPersonIDLayer(blood[sb].id1, blood_splat_layer);
			
				
			
			if (damage == undefined)
			  damage = 2;
			
			length = Math.sqrt(vx*vx+vy*vy);
			sx = sconst*Math.sqrt(damage)*(vx/length);
			sy = sconst*Math.sqrt(damage)*(vy/length);
			/*
			font.drawText(0,0, damage);
			FlipScreen();
			GetKey();
			*/
			if (damage < 3)
				SpawnBlood(x,y,sx+Math.random()*damage/2-damage/4,sy+Math.random()*3-2,3, "");
			else if (damage < 6)
				SpawnBlood(x,y,sx+Math.random()*damage/2-damage/4,sy+Math.random()*3-2,2, "");
			else 
				SpawnBlood(x,y,sx+Math.random()*damage/2-damage/4,sy+Math.random()*3-2,1, "");

			AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor(y/GetTileHeight()),1);

				
			return;
		}
	}
}

function SpawnSparkSplat(x,y, dam)
{
	for (sb = 0;sb<max_spark;sb++)
	{
		if (spark[sb].x == -100)
		{
			spark[sb].x = x;
			spark[sb].y = y;
			
			spark[sb].type = 1;
			spark[sb].dir = "hit1";
			
			if (dam > 10)
			{
				spark[sb].dir = "hit2";
			}
			spark[sb].frame = 1;
				
//			MarkBlood(x,y);
			return;
		}
	}
}













function MarkBlood(x,y)
{

	var w = GetTileWidth();
	var h = GetTileHeight();
	var tx = Math.floor(x/w);
	var ty = Math.floor(y/h);
	
	var tilec,tilel,tiler,tileu,tiled, tiledl, tiledr;
	if (tx < 0 || tx > GetLayerWidth(0)-1 ||
			ty < 0 || ty > GetLayerHeight(0)-1)
	return;
	
	tilec = GetTile(Math.floor(x/w),Math.floor(y/h), 0);
	
	tilel = tilec;	tiler = tilec;	tileu = tilec;	tiled = tilec;
	if (tx > 0)
		tilel = GetTile(tx-1,ty, 0);
	if (tx < GetLayerWidth(0)-1)
		tiler = GetTile(tx+1,ty, 0);
	
	if (ty > 0)
		tileu = GetTile(tx,ty-1, 0);
	if (ty < GetLayerHeight(0)-1)
		tiled = GetTile(tx,ty+1, 0);

	tiledl= tiled;  
	tiledr= tiled;  


	if (tx > 0 && ty < GetLayerHeight(0)-1)
		tiledl = GetTile(tx-1,ty+1, 0);
	if (tx < GetLayerWidth(0)-1 && ty < GetLayerHeight(0)-1)
		tiledr = GetTile(tx+1,ty+1, 0);
	
	if (tilec == 189)
		tilec = 0;
	if (tilel == 189)
		tilel = 0;
	if (tiler == 189)
		tiler = 0;
	if (tileu == 189)
		tileu = 0;
	if (tiled == 189)
		tiled = 0;
	if (tiledl == 189)
		tiledl = 0;
	if (tiledr == 189)
		tiledr = 0;
	
	if (tilec == 279)
		tilec = 0;
	if (tilel == 279)
		tilel = 0;
	if (tiler == 279)
		tiler = 0;
	if (tileu == 279)
		tileu = 0;
	if (tiled == 279)
		tiled = 0;
	if (tiledl == 279)
		tiledl = 0;
	if (tiledr == 279)
		tiledr = 0;
		
	var b_tilec, b_tilel, b_tiler;

//	if (changey <=0)
//	  return;
//	changey--;	
	//(with reference to tile c....
	function IsCornerTile(x,y)
	{
		var tempyt = 0;
	  if (GetTile(x,y, 0) != 1)
	    return 0;
	  if (y<GetLayerHeight(0)-1)
	  {
			if (GetTile(x,y+1, 0) != 1)
				return 0;
	  }
	  else
	    return 0;

		if (x > 1)
		{
			tempyt = GetTile(x-1,y+1,0);
			if (tempyt == 189 || tempyt == 279)
				tempyt = 0;
			if (GetTile(x-1,y,0) == 1 && tempyt == 0)
			{
			  return 2;
			}
		}
		if (x < GetLayerWidth(0)-2)
		{
			tempyt = GetTile(x+1,y+1,0);
			if (tempyt == 189 || tempyt == 279)
				tempyt = 0;
			if (GetTile(x+1,y,0) == 1 && tempyt == 0)
			  return 1;
		}
	
	}

	function AddBlood(x,y,num, num2,type)
	{
		var p_tile;
		
	  if (num == 0 && x>0)
	  {
	    p_tile = GetTile(x-1,y, blood_layer);
	    if (bcal[p_tile][0] > -1)
				SetTile(x-1,y,blood_layer, bcal[p_tile][0]);
	    else if (bcal[p_tile][0] == -2)
	    {
	      if (IsCornerTile(x-1,y)== 1)
	      {
					SetTile(x-1,y,blood_layer, 70);
	        AddBlood(x-1,y, 3, 43); 
				}
				else
					SetTile(x-1,y,blood_layer, num2);
			}
	  }
	  else if (num == 1 && x<GetLayerWidth(blood_layer)-1)
	  {
	    p_tile = GetTile(x+1,y, blood_layer);

	    if (bcal[p_tile][1] > -1)
				SetTile(x+1,y,blood_layer, bcal[p_tile][1]);
	    else if (bcal[p_tile][1] == -2)
	    {
	      if (IsCornerTile(x+1,y)== 2)
	      {
					SetTile(x+1,y,blood_layer, 69);
	        AddBlood(x+1,y, 3, 21); 
				}
				else
				SetTile(x+1,y,blood_layer, num2);
			}

	  }
	  else if (num == 2 && y > 0)
	  {
	    p_tile = GetTile(x,y-1, blood_layer);
	    if (bcal[p_tile][2] > -1)
				SetTile(x,y-1,blood_layer, bcal[p_tile][2]);
	    else if (bcal[p_tile][2] == -2)
	    {
	      if (IsCornerTile(x,y-1)== 1)
	      {
					SetTile(x,y-1,blood_layer, 70);
	        AddBlood(x,y-1, 1, 63); 
				}
	      else if (IsCornerTile(x,y-1)== 2)
	      {
					SetTile(x,y-1,blood_layer, 69);
	        AddBlood(x,y-1, 0, 61); 
				}
				else
					SetTile(x,y-1,blood_layer, num2);
			}
	  }
	  else if (num == 3 && y<GetLayerHeight(blood_layer)-1)
	  {
	    p_tile = GetTile(x,y+1, blood_layer);
	    if (bcal[p_tile][3] > -1)
				SetTile(x,y+1,blood_layer, bcal[p_tile][3]);
	    else if (bcal[p_tile][3] == -2)
				SetTile(x,y+1,blood_layer, num2);
	  }

	}
		
		
		
		
		
	//check for top stain
	if (tilec == 2 &&  tiler != 0 && tilel != 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 10);
		else if (bca[b_tilec] > -1)
		  SetTile(tx,ty, blood_layer, bca[b_tilec]);
		  
		if (bca[b_tilec] == 7)
		{
		  AddBlood(tx,ty,0,6);
		  AddBlood(tx,ty,1,8);
		}
	}
	//check for top 2 left stain
	else if (tilec == 1 &&  tiler == 0 && tilel == 1&&(tileu == 1||tileu == 2)&&tiled == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 85);
		else if (bca[b_tilec] > -1)
		{
		  if (b_tilec == 43)
				SetTile(tx,ty, blood_layer, 86);
		  else if (b_tilec == 63)
				SetTile(tx,ty, blood_layer, 87);
		  else 
				SetTile(tx,ty, blood_layer, 88);
//		  SetTile(tx,ty, blood_layer, bca[b_tilec]);
		}
		  
		if (bca[b_tilec] == 88)
		{
			SpawnDrip1(tx*GetTileWidth()+8,(ty+1)*GetTileHeight()+8, 5, 3);
		  AddBlood(tx,ty,0,61);
		  AddBlood(tx,ty,2,41);
		}
	}
	//check for top 2 right stain
	else if (tilec == 1 &&  tiler == 1 && tilel == 0&&(tileu == 1||tileu == 2)&&tiled == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 90);
		else if (bca[b_tilec] > -1)
		{
		  if (b_tilec == 21)
				SetTile(tx,ty, blood_layer, 91);
		  else if (b_tilec == 61)
				SetTile(tx,ty, blood_layer, 92);
		  else 
				SetTile(tx,ty, blood_layer, 93);
//		  SetTile(tx,ty, blood_layer, bca[b_tilec]);
		}
		  
		if (bca[b_tilec] == 93)
		{
			SpawnDrip1(tx*GetTileWidth()+8,(ty+1)*GetTileHeight()+8, 5, 3);
		  AddBlood(tx,ty,1,63);
		  AddBlood(tx,ty,2,23);
		}
	}

	//check for bottom 2 right stain
	else if (tilec == 1 && tiled != 0 && tilel == 1 && tiledl == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		{
		  SetTile(tx,ty, blood_layer, 69);
      AddBlood(tx,ty, 0, 61); 
      AddBlood(tx,ty, 3, 21);
		}
//		else if (bca[b_tilec] > -1)
//		  SetTile(tx,ty, blood_layer, bca[b_tilec]);

/*

...???????


*/
	}
	//check for bottom 2 left stain
	else if (tilec == 1 && tiled != 0 && tiler == 1 && tiledr == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
	  
	
		if (bca[b_tilec] == -2)
		{
		  SetTile(tx,ty, blood_layer, 70);
      AddBlood(tx,ty, 1, 63);
      AddBlood(tx,ty, 3, 43);
		}
//		else if (bca[b_tilec] > -1)
//		  SetTile(tx,ty, blood_layer, bca[b_tilec]);
/*

...???????


*/
	}
	//check for right stain
	else if (tilec == 1 && tiler == 0 && tileu != 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 45);
		else if (bca[b_tilec] > -1)
		  SetTile(tx,ty, blood_layer, bca[b_tilec]);

		if (bca[b_tilec] == 42)
		{
		  AddBlood(tx,ty,2,41);
		  AddBlood(tx,ty,3,43);
		}
	}
	//check for top right stain
	else if (tilec == 2 && tiler == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 55);
		else if (bca[b_tilec] > -1)
		{
			if (b_tilec == 8)
				SetTile(tx,ty, blood_layer, 80);
			else if (b_tilec == 41)
				SetTile(tx,ty, blood_layer, 81);
			else if (b_tilec == 54)
				SetTile(tx,ty, blood_layer, 53);
			else 
				SetTile(tx,ty, blood_layer, bca[b_tilec]);
		}
		
		if (bca[b_tilec] == 53)
		{
		  AddBlood(tx,ty,0,6);
		  AddBlood(tx,ty,3,43);
		}
	}
	//check for bottom right stain
	else if (tilec == 1 && tiler == 2)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 56);
		else if (bca[b_tilec] > -1)
		{
			if (b_tilec == 6)
				SetTile(tx,ty, blood_layer, 82);
			else if (b_tilec == 43)
				SetTile(tx,ty, blood_layer, 83);
			else 
				SetTile(tx,ty, blood_layer, 52);//bca[b_tilec]);
		}

		if (bca[b_tilec] == 52)
		{
		  AddBlood(tx,ty,1,8);
		  AddBlood(tx,ty,2,41);
		}
	}
	
	//check for left stain
	else if (tilec == 1 && tilel == 0 && tileu != 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 25);
		else if (bca[b_tilec] > -1)
		  SetTile(tx,ty, blood_layer, bca[b_tilec]);

		if (bca[b_tilec] == 22)
		{
		  AddBlood(tx,ty,2,23);
		  AddBlood(tx,ty,3,21);
		}
	}
	//check for top left stain
	else if (tilec == 2 && tilel == 0)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 35);
		else if (bca[b_tilec] > -1)
		{
			if (b_tilec == 6)
				SetTile(tx,ty, blood_layer, 75);
			else if (b_tilec == 23)
				SetTile(tx,ty, blood_layer, 76);
			else if (b_tilec == 34)
				SetTile(tx,ty, blood_layer, 33);
			else 
				SetTile(tx,ty, blood_layer, bca[b_tilec]);
		}

		if (bca[b_tilec] == 33)
		{
		  AddBlood(tx,ty,1,8);
		  AddBlood(tx,ty,3,21);
		}
	}
	//check for bottom left stain
	else if (tilec == 1 && tilel == 2)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 36);
		else if (bca[b_tilec] > -1)
		{
			if (b_tilec == 8)
				SetTile(tx,ty, blood_layer, 77);
			else if (b_tilec == 21)
				SetTile(tx,ty, blood_layer, 78);
			else 
				SetTile(tx,ty, blood_layer, 32);//bca[b_tilec]);
		}

		if (bca[b_tilec] == 32)
		{
		  AddBlood(tx,ty,0,6);
		  AddBlood(tx,ty,2,23);
		}
	}

	//check for bottom stain
	else if (tilec == 1 && tiled == 0 && tilel == 1 && tiler == 1)
	{
	  b_tilec=GetTile(tx,ty, blood_layer);
		
		if (bca[b_tilec] == -2)
		  SetTile(tx,ty, blood_layer, 65);
		else if (bca[b_tilec] > -1)
		  SetTile(tx,ty, blood_layer, bca[b_tilec]);

		if (bca[b_tilec] == 62)
		{
			SpawnDrip1(tx*GetTileWidth()+8,(ty+1)*GetTileHeight()+8, 5, 3);
		  AddBlood(tx,ty,0,61);
		  AddBlood(tx,ty,1,63);
		}
	}
	else
	{
	}
}

function MarkBlood2(tx,ty, type)
{
  if (type == "t")
  {
		//
  }


}

function ClearAllBlood()
{
	for (i=0;i<GetLayerWidth(blood_layer);i++)
	{
		for (j=0;j<GetLayerHeight(blood_layer);j++)
		{
			SetTile(i,j, blood_layer, 0);
			SetTile(i,j, back_blood_layer, 0);
		}
	}
}






function UpdateTrails()
{
  var sx, sy;
  var gravity_const = 0.5;
  var max_fall = 7;
  var speed = 10;
  var vx,vy;
  
  var w = GetTileWidth();
  var h = GetTileHeight();


  for (i=0;i<max_trails;i++)
  {
    if (btrails[i].x > blood_dx)
    {
      SetPersonIDLayer(btrails[i].id1, 0);
      if (btrails[i].flamed != 1)
      {
				if (btrails[i].flamed == 3)
				{
					if (!IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y+btrails[i].vy) && btrails[i].vy != 0)
					{
						if (btrails[i].vy < max_fall)
							btrails[i].vy+=gravity_const;
						btrails[i].y+=btrails[i].vy;
					}
					else if (btrails[i].vy != 0)
					{
						for (j=0;j<speed;j++)
						{
							btrails[i].y -=btrails[i].vy/speed;
							if (!IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y))
	//							if (!(GetTile(btrails[i].x/w, btrails[i].y/h,0) != 0))
								break;
						}
						btrails[i].vy = 0;
					}
					else if (!IsPersonIDObstructed(btrails[i].id1, btrails[i].x+btrails[i].vx, btrails[i].y))
					{
							btrails[i].x+=btrails[i].vx;
					}	
					else
					{
						PlaySound(34);
						btrails[i].x= blood_dx;
					}
					
				}
				else
				{
					if (btrails[i].vy < max_fall)
						btrails[i].vy+=gravity_const;

					btrails[i].x+=btrails[i].vx;
					btrails[i].y+=btrails[i].vy;
				}
				
				if (IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y))
//				if (GetTile(btrails[i].x/w, btrails[i].y/h,0) != 0) 
				{
					for (j=0;j<speed;j++)
					{
						btrails[i].x -=btrails[i].vx/speed;
						btrails[i].y -=btrails[i].vy/speed;
						if (!IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y))
//							if (!(GetTile(btrails[i].x/w, btrails[i].y/h,0) != 0))
							break;
					}
	
					sx = btrails[i].vx;
					sy = btrails[i].vy;
	
	
					if (IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y+1))
//					if (GetTile((btrails[i].x)/w, (btrails[i].y+1)/h, 0) != 0)
						btrails[i].vy=0;
					if (IsPersonIDObstructed(btrails[i].id1, btrails[i].x+1, btrails[i].y))
//					if (GetTile((btrails[i].x+1)/w, (btrails[i].y)/h, 0) != 0)
						btrails[i].vx=0;
	
	
					if (IsPersonIDObstructed(btrails[i].id1, btrails[i].x, btrails[i].y-1))
//					if (GetTile((btrails[i].x)/w, (btrails[i].y-1)/h, 0) != 0)
						btrails[i].vy=0;
					if (IsPersonIDObstructed(btrails[i].id1, btrails[i].x-1, btrails[i].y))
//					if (GetTile((btrails[i].x-1)/w, (btrails[i].y)/h, 0) != 0)
						btrails[i].vx=0;
						
					if (btrails[i].flamed < 2 && btrails[bi].green != true && btrails[bi].black != true)
					{
						if (sx != btrails[i].vx)
						{
							if (Math.abs(sx) > 2)
								PlaySound(34);
	
							if (sx > 0)
								MarkBlood(btrails[i].x+8, btrails[i].y+sy);
							else if (sx < 0)
								MarkBlood(btrails[i].x-8, btrails[i].y+sy);
							else
								MarkBlood(btrails[i].x, btrails[i].y+sy);
	
							if (btrails[i].owner != "w")
							{/*
								var tempyy = Math.abs(sx);
								if (tempyy > 5)
									tempyy = 5;
								PlaySound(2,128+255*tempyy/10, 0);
								*/
							}
						}
						if (sy != btrails[i].vy)
						{
							if (Math.abs(sy) > 2)
								PlaySound(34);
	
							if (sy > 0)
								MarkBlood(btrails[i].x+sx, btrails[i].y+8);
							else if (sx < 0)
								MarkBlood(btrails[i].x+sx, btrails[i].y-8);
							else
								MarkBlood(btrails[i].x+sx, btrails[i].y+sy);
	
							if (btrails[i].owner != "w")
							{/*
								var tempyy = Math.abs(sy);
								if (tempyy > 5)
									tempyy = 5;
								PlaySound(2,128+255*tempyy/10,0);
								*/
							}
						}
					}
	
					if (btrails[i].flamed == 2)
					{
						PlaySound(34);
					}
					btrails[i].x = blood_dx;
					btrails[i].y = blood_dy;
				}
			
				if (btrails[i].flamed < 2)
				{
					btrails[i].rotation=Math.atan2(btrails[i].vy, btrails[i].vx);
	
					vx = btrails[i].vx;
					vy = btrails[i].vy;
					btrails[i].speed = Math.sqrt(vx*vx+vy*vy);
					
	
					if (btrails[i].speed < 1)
						SetPersonIDFrame(btrails[i].id1,0);
					else if (btrails[i].speed < 2)
						SetPersonIDFrame(btrails[i].id1,1);
					else if (btrails[i].speed < 4)
						SetPersonIDFrame(btrails[i].id1,2);
					else if (btrails[i].speed < 6)
						SetPersonIDFrame(btrails[i].id1,3);
					else 
						SetPersonIDFrame(btrails[i].id1,4);
	
					SetPersonIDX(btrails[i].id1, btrails[i].x);
					SetPersonIDY(btrails[i].id1, btrails[i].y);
					SetPersonIDAngle(btrails[i].id1, btrails[i].rotation);
				}
				else
				{
					if (g_frames%4==0)
						btrails[i].frame++;

					SetPersonIDFrame(btrails[i].id1,btrails[i].frame);
	
					SetPersonIDX(btrails[i].id1, btrails[i].x);
					SetPersonIDY(btrails[i].id1, btrails[i].y);


					if (btrails[i].frame == 17)
						btrails[i].x = blood_dx;
						
					//check for damage:	
					if (entities[0].hp > 0 && 0 != btrails[i].owner && !(entities[0].invince > 0))
					{
						lengthx = (entities[0].x-btrails[i].x);
						lengthy = (entities[0].y-btrails[i].y);
						if (Math.sqrt(lengthx*lengthx + lengthy*lengthy) < btrails[i].blast_radius)
						{
							RemovePlayerHP(btrails[i].damage);
							entities[0].invince = invince_max;
						}
					}
				}
			}
			else
			{
				if (g_frames%4==0)
					btrails[i].frame++;
	
				SetPersonIDX(btrails[i].id1, btrails[i].x);
				SetPersonIDY(btrails[i].id1, btrails[i].y);
				SetPersonIDFrame(btrails[i].id1, btrails[i].frame);
		
				if (btrails[i].frame == 5)
					btrails[i].x = blood_dx;
			}

			if (g_supernaut_active > 0)
				SetPersonIDLayer(btrails[i].id1, g_supernaut_head_layer+1);
			else
				SetPersonIDLayer(btrails[i].id1, blood_layer);
	  }
	  else
	  {
			SetPersonIDX(btrails[i].id1, btrails[i].x);
	  }
  }
}

function SpawnBlood(x,y,vx,vy,size, owner, flamed, drip, green, black)
{
  bi = 0;
  for (bi=0;bi<max_trails;bi++)
  {
    if (btrails[bi].x == blood_dx)
      break;
  }
  
  if (x > -20 && y > -20 && vx > -20 && vy > -20)
  ;
  else
    return;
  
  var sx,sy;
  var length = Math.sqrt(vx*vx+vy*vy);
  sx = 6*vx/length;
  sy = 6*vy/length;
  
  if (bi<max_trails-5)
  {
		if (drip != true)
		{
			btrails[bi].x = x+3*sx;
			btrails[bi].y = y+1*sy;
		}
		else
		{
			btrails[bi].x = x;
			btrails[bi].y = y;
		}
    btrails[bi].vx = vx;
    btrails[bi].vy = vy;
    btrails[bi].frame = 0;
    if (flamed != 1)
    btrails[bi].flamed = 0;
    if (owner == undefined)
			btrails[bi].owner = "";
		else
			btrails[bi].owner = owner;

		if (green != undefined)
		{
			btrails[bi].green = true;
			btrails[bi].black = false;
			SetPersonMask("bt"+bi, CreateColor(128,255,255,255));
		}
		else if (black !=undefined)
		{
			btrails[bi].black = true;
			btrails[bi].green = false;
			SetPersonMask("bt"+bi, CreateColor(0,0,0,255));
		}
		else
		{
			btrails[bi].green = false;
			btrails[bi].black = false;
			SetPersonMask("bt"+bi, CreateColor(255,255,255,255));
		}


		if (!(btrails[bi].x > -100)||!(btrails[bi].y > -100))
		{
			btrails[bi].x = -100;
			btrails[bi].y = 0;
			btrails[bi].vx = 0;
			btrails[bi].vy = 0;
			return;
		}
		
		if (!(btrails[bi].vx > -20) ||!(btrails[bi].vy > -20))
		{
			btrails[bi].vx = 0;
			btrails[bi].vy = 0;
			
		}

    
    SetPersonIDDirection(btrails[bi].id1, "trail"+size);
		if (g_supernaut_active > 0)
			SetPersonIDLayer(btrails[bi].id1, g_supernaut_head_layer+1);
		else
			SetPersonIDLayer(btrails[bi].id1, blood_layer);


    SetPersonIDX(btrails[bi].id1, btrails[bi].x);
    SetPersonIDY(btrails[bi].id1, btrails[bi].y);
	}
}

function SpawnFlame(x,y,vx,vy,type)
{
  bi = 0;
  for (bi=0;bi<max_trails;bi++)
  {
    if (btrails[bi].x == blood_dx)
      break;
  }

  if (bi<max_trails-5)
  {
		btrails[bi].x = x;
		btrails[bi].y = y;

    btrails[bi].vx = vx;
    btrails[bi].vy = vy;
    btrails[bi].frame = 0;
    btrails[bi].flamed = 1;
    
    SetPersonIDDirection(btrails[bi].id1, "flame");
    SetPersonIDLayer(btrails[bi].id1, blood_layer);
    SetPersonIDX(btrails[bi].id1, btrails[bi].x);
    SetPersonIDY(btrails[bi].id1, btrails[bi].y);
	}
}


function SpawnDeadlyFlame(x,y,vx,vy,owner)
{
  bi = 0;
  for (bi=0;bi<max_trails;bi++)
  {
    if (btrails[bi].x == blood_dx)
      break;
  }

  if (bi<max_trails-5)
  {
		btrails[bi].x = x;
		btrails[bi].y = y;

    btrails[bi].vx = vx;
    btrails[bi].vy = vy;
    btrails[bi].frame = 0;
    btrails[bi].flamed = 2;
    btrails[bi].owner = owner;

		btrails[bi].blast_radius = 16;
		btrails[bi].damage = 2;
    
    if (g_current_level == 18)
      SetPersonIDDirection(btrails[bi].id1, "flame2g");
    else
      SetPersonIDDirection(btrails[bi].id1, "flame2");
    SetPersonIDLayer(btrails[bi].id1, blood_layer);
    SetPersonIDX(btrails[bi].id1, btrails[bi].x);
    SetPersonIDY(btrails[bi].id1, btrails[bi].y);
	}
}

function SpawnDeadlyFlame2(x,y,vx,vy,owner)
{
  bi = 0;
  for (bi=0;bi<max_trails;bi++)
  {
    if (btrails[bi].x == blood_dx)
      break;
  }

  if (bi<max_trails-5)
  {
		btrails[bi].x = x;
		btrails[bi].y = y;
		if (Math.random()<0.5)
			btrails[bi].vx = 6;
    else
			btrails[bi].vx = -6;

    btrails[bi].vy = 6;
    btrails[bi].frame = 0;
    btrails[bi].flamed = 3;
    btrails[bi].owner = owner;

		btrails[bi].blast_radius = 16;
		btrails[bi].damage = 2;
    
    SetPersonIDDirection(btrails[bi].id1, "flame2");
    SetPersonIDLayer(btrails[bi].id1, blood_layer);
    SetPersonIDX(btrails[bi].id1, btrails[bi].x);
    SetPersonIDY(btrails[bi].id1, btrails[bi].y);
	}
}


function SpawnGuts(ent, x,y,vx,vy, type, flamed, layer, mask)
{
	var tw = Math.floor(x/GetTileWidth());
	var th = Math.floor(y/GetTileWidth());

	if (GetTile(tw,th, 0) == 1174)
		return;
	if (th > 0)
		if (GetTile(tw,th-1, 0) == 1174)
			return;
	if (th < GetLayerHeight(0)-1)
		if (GetTile(tw,th+1, 0) == 1174)
			return;
	if (g_supernaut_active == 2)
	{
		if (vx > 0)
			vx = -1*vx;
	}
	
	if (ent > -1)
	{
		if (entities[ent].type == 3)
		{
			if (type.substr(0,6) == "enemy1")
			  type = "enemy2"+type.substr(6,type.length);
		}
		if (entities[ent].type == 5)
		{
			if (type.substr(0,6) == "enemy1")
			  type = "eye1"+type.substr(6,type.length);
		}
	}

	

  //add the gut object
  if (g_current_level == 18)
		CreatePerson("gut"+max_guts, "gray/g_guts1.rss", true);
	else
		CreatePerson("gut"+max_guts, "guts1.rss", true);
  IgnorePersonObstructions("gut"+max_guts, true);
  if (type.charAt(0) != "g")
  {
//		SetPersonMask("gut"+max_guts, mask);
  }
  
	guts[max_guts] = new Object();
	var gut = guts[max_guts];
	gut.x = x;
	gut.y = y;

	gut.vx = vx;
	gut.vy = vy;

	gut.name = "gut"+max_guts;

	gut.id1 = GetPersonID("gut"+max_guts);
	gut.frame = 0;
	gut.direction = type;
	gut.flamed = flamed;
	
	if (flamed == true)
		gut.direction+="f";
		
	gut.blood = 1;
	if (ent == -4)
	{
		//supernaut type
		gut.scalefactor = 0.8+0.2*Math.random();
	}
	else if (ent == -3)
	{
		gut.blood = 1;
	  if (Math.random() < 0.333333)
			gut.direction = "guts2";
		else if (Math.random() < 0.5)
			gut.direction = "guts3";
		else
			gut.direction = "guts4";
	}
	else if (ent == -2)
	{
		gut.blood = 0;
	  if (Math.random() < 0.333333)
			gut.direction = "shrap1_1";
		else if (Math.random() < 0.5)
			gut.direction = "shrap1_2";
		else
			gut.direction = "shrap1_3";
	}
	else if (ent == -1 || (ent >= 0 && entities[ent].type == 2))
	{
		gut.blood = 0;
	  if (Math.random() < 0.333333)
			gut.direction = "barrel1_1";
		else if (Math.random() < 0.5)
			gut.direction = "barrel1_2";
		else
			gut.direction = "barrel1_3";
	}
	else if (ent > -1)
	{
		if ((entities[ent].type == 1||entities[ent].type == 3) && entities[ent].hp>0)
		{
			PlaySound(42,true);
		}
	}
	
	if (gut.blood != 0)
	{
		AddScore(1);
		if (flamed==true)
			AddScore(1);
	}
	
	gut.rotation = 0;
	if (g_fireshift == 1)
		gut.layer = gut_layer;
	else
		gut.layer = layer;

	gut.layer_old = -1;
	if (g_supernaut_active > 0)
	{
		gut.layer_old = layer;
		gut.layer = gut_layer+2;
	}

	max_guts++;

  SetPersonIDX(gut.id1, x);
  SetPersonIDY(gut.id1, y);
  SetPersonIDLayer(gut.id1, gut.layer);
  
  if (gut.scalefactor > 0)
  {
//		SetPersonIDScaleFactor(gut.id1, gut.scalefactor, gut.scalefactor);
  }

	SetPersonIDDirection(gut.id1, gut.direction);

//whatever
	if (vx > 0)
		SetPersonIDHorizontalFlip(gut.id1, 0);
	if (vx < 0)
		SetPersonIDHorizontalFlip(gut.id1, 1);
}


function UpdateGuts()
{
  var sx, sy;
  var gravity_const = 0.5;
  var max_fall = 7;
  var speed = 10;
  var friction = 0.25;
  var bool = false;
  
  var gx,gy;
  
  var gut;
  var rate = 1;

	for (i=min_guts;i<max_guts;i++)
	{
		if (guts[i].name != "")
		{
		
			gut = guts[i];
			if (min_guts < i && bool == false)
				min_guts = i;
			bool  = true;

				SetPersonIDLayer(gut.id1, 0);
				if (IsPersonIDObstructed(gut.id1, gut.x, gut.y))
				{
					gut.x=-16;
					gut.name = "";

					SetPersonIDX(gut.id1, -400);				
					//remove it!
				}
					
					
	//				GetKey();
		
				if (gut.vy < max_fall && !IsPersonIDObstructed(gut.id1, gut.x, gut.y+1))
					gut.vy+=gravity_const;
					
	
				if (IsXYInWater(gut.x,gut.y))
				{
					if (gut.vy > 1)
						gut.vy-=1;
					if (gut.vy <-1)
						gut.vy+=1;
					if (gut.vx > 1)
						gut.vx-=1;
					if (gut.vx <-1)
						gut.vx+=1;
				}


				gut.x+=gut.vx;
				gut.y+=gut.vy;
				
				if (g_boss_active == 1)
				{
					if (gut.x > 70*16+128*16)
					{
						gut.x = 70*16+128*16;
						if (gut.vx > 0)
							gut.vx=0;
					}
				}
				
				
				gx = gut.x;
				gy = gut.y;
				
				if (IsPersonIDObstructed(gut.id1, gut.x, gut.y))
				{
					for (j=0;j<speed;j++)
					{
						gut.x -=gut.vx/speed;
						gut.y -=gut.vy/speed;
						if (!IsPersonIDObstructed(gut.id1, gut.x, gut.y))
							break;
					}
		
		
					sx = gut.vx;
					sy = gut.vy;
		
		
					if (IsPersonIDObstructed(gut.id1, gut.x, gut.y+1))
						gut.vy=0;
					if (IsPersonIDObstructed(gut.id1, gut.x+1, gut.y))
						gut.vx=0;
		
		
					if (IsPersonIDObstructed(gut.id1, gut.x, gut.y-1))
						gut.vy=0;
					if (IsPersonIDObstructed(gut.id1, gut.x-1, gut.y))
						gut.vx=0;
							
					if (sx==gut.vx && sy == gut.vy)
						gut.vx = 0;
						
					if (sx != gut.vx)
					{
						if (gut.blood == 0)
						{
							if (Math.abs(sx) > 1)
								PlaySound(37,true);
						}
					}
					if (sy != gut.vy)
					{
						if (gut.blood == 0)
						{
							if (Math.abs(sy) > 1)
								PlaySound(37,true);
						}
					}
							



					if (sx != gut.vx && gut.blood == 1)
					{
						MarkBlood(gx+sx,gy);
	//					BloodStain(guts[i].x, guts[i].y, sx, sy, "x");
	/*
						var tempyy = Math.abs(sx);
						if (tempyy > 5)
							tempyy = 5;
						if (i%2 == 0)
						PlaySound(3,128+255*tempyy/5, 0.10);
	*/
					}
					if (sy != gut.vy&& gut.blood == 1)
					{
						MarkBlood(gx,gy+sy);
	//					BloodStain(guts[i].x, guts[i].y, sx, sy, "y");
	/*
						var tempyy = Math.abs(sy);
						if (tempyy > 5)
							tempyy = 5;
	
						if (i%2 == 0)
						{
							if (sy>1.5)
								PlaySound(3,128+255*tempyy/5, 0.10);
						}
	*/					
					}
				}
				
				if (gut.vx < 0 && IsGutOnGround(gut))
				{
					gut.vx+=friction/4;
					if (gut.vx > 0)
						gut.vx = 0;
				}
				else if (gut.vx > 0 && IsGutOnGround(gut))
				{
					gut.vx-=friction/4;
					if (gut.vx < 0)
						gut.vx = 0;
				}
		
	//			if (guts[i].rotate == true)
	//				guts[i].rotation+=guts[i].vx*0.02;

				if (g_frames%2 == 0 || i%rate == 0)
					SetPersonIDX(gut.id1, gut.x);
				else
					SetPersonIDX(gut.id1, -400);
				
				if (gut.layer == gut_layer)
					SetPersonIDY(gut.id1, gut.y-1);
				else
					SetPersonIDY(gut.id1, gut.y+1);
					
				SetPersonIDAngle(gut.id1, gut.rotation);
				if (IsGutOnGround(gut))
					SetPersonIDFrame(gut.id1, 2);
				else
					SetPersonIDFrame(gut.id1, Math.floor(g_frames/4)%2);
				
				if (IsGutOnGround(gut) && gut.vx == 0)
				{
					gut.name = "";

					if (gut.layer_old > 0)
						gut.layer = gut.layer_old;

					if (i%rate == 0)
						SetPersonIDX(gut.id1, gut.x);
					else
						SetPersonIDX(gut.id1, -400);
				}
				else if (g_frames%b_rate == i%b_rate && gut.flamed == true)
					SpawnFlame(guts[i].x,guts[i].y,guts[i].vx*b_slowx,guts[i].vy*b_slowy,3);
				else if (g_frames%b_rate == i%b_rate && !IsGutOnGround(gut)&& gut.blood == 1)
					SpawnBlood(gut.x,gut.y,gut.vx*b_slowx,gut.vy*b_slowy,3, "w");
				else if (IsGutOnGround(gut) && gut.blood == 1)
					MarkBlood(gx,gy)
	
				if (gut.x < -16 || gut.x > GetLayerWidth(gut_layer)*16+16)
				{
					gut.x=-16;
					gut.name = "";

					SetPersonIDX(gut.id1, -400);

				}
				SetPersonIDLayer(gut.id1, gut.layer);
		}	
	}
}

function IsGutOnGround(num)
{
	if (IsPersonIDObstructed(num.id1, num.x, num.y+1) && Math.abs(num.vy) < 1.5)
		return true;
	return false;
}



function SpawnArm(i,x,y, vx,vy, layer, mask)
{
  if (layer == undefined)
    layer = gut_layer;
	if (entities[i].type == 1)
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "enemy1_arm", 0, layer, entities[i].mask);
	if (entities[i].type == 2)
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "barrel1_1", 0, layer, entities[i].mask);
	if (entities[i].type == 3)
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "enemy2_arm", 0, layer, entities[i].mask);
	if (entities[i].type == 5)
	{
		if (layer == gut_layer)
			SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "eye1_arm", 0, layer, entities[i].mask);
		else
			SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "eye1_guts1", 0, layer, entities[i].mask);
	}
	if (entities[i].type == 6)
	{
		PlaySound(115, true);
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "id_arm", 0, layer, entities[i].mask);
	}
	if (entities[i].type == 7)
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "mantis_arm", 0, layer, entities[i].mask);
	if (entities[i].type == 8)
	{
		SpawnGuts(i,entities[i].x,entities[i].y,vx,vy, "drone_legs1", 0, layer, entities[i].mask);
	}
}

function SpawnHead(numy,x,y, vx,vy, explode)
{
	if (entities[numy].type == 9 || entities[numy].type == 10)
	{
		if (entities[numy].type == 9)
			PlaySound(109, true);
		if (entities[numy].type == 10)
			PlaySound(110, true);

		return;
	}
	if (entities[numy].type == 2)
	{
		var btx = entities[numy].x/GetTileWidth();
		var bty = entities[numy].y/GetTileHeight();
		if (GetTile(btx,bty-1,0) != 0)
		{
			SetTile(btx,bty-1, 0,0);
		}
		
		//remove local guts
		for (sh=0;sh<max_guts;sh++)
		{
			if (Math.abs(guts[sh].x - x) < 32 && Math.abs(guts[sh].y - y) < 32)
			{
				guts[sh].x = -100;
				SetPersonIDX(guts[sh].id1, guts[sh].x);
			}
		}

		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		
		if (entities[numy].type == 1)
		{
			SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp1 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp2 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp3 > 0)
			{
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				if (Math.random() < 0.5)
					SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			}
		}
		else if (entities[numy].type == 3)
		{
			SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp1 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp2 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp3 > 0)
			{
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				if (Math.random() < 0.5)
					SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			}
		}

	  return;
	}
	else if (entities[numy].type == 11)
	{
		var btx = entities[numy].x/GetTileWidth();
		var bty = entities[numy].y/GetTileHeight();
		if (GetTile(btx-1,bty+1,0) != 0)
		{
			SetTile(btx-1,bty+1, 0,0);
			SetTile(btx,bty+1, 0,0);
			SetTile(btx-1,bty+2, 0,0);
			SetTile(btx,bty+2, 0,0);
		}
		
		//remove local guts
		for (sh=0;sh<max_guts;sh++)
		{
			if (Math.abs(guts[sh].x - x) < 32 && Math.abs(guts[sh].y - y) < 32)
			{
				guts[sh].x = -100;
				SetPersonIDX(guts[sh].id1, guts[sh].x);
			}
		}

		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
		
		if (entities[numy].type == 11)
		{
			PlaySound(46);
			for (k=0;k<4;k++)
			{
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-2+4*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-2+4*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-2+4*Math.random(),-7+2*Math.random(), "guts"+(2+Math.floor(3*Math.random())), 1, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			}
			g_heart_die = g_heart_max;
		}

		if (entities[numy].type == 1)
		{
			SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp1 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp2 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp3 > 0)
			{
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				if (Math.random() < 0.5)
					SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			}
		}
		else if (entities[numy].type == 3)
		{
			SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_guts1", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp1 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp2 > 0)
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_arm", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			if (entities[numy].hp3 > 0)
			{
				SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy2_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
				if (Math.random() < 0.5)
					SpawnGuts(numy,entities[numy].x,entities[numy].y,entities[numy].vx-1+2*Math.random(),-7+2*Math.random(), "enemy1_leg", 0, gut_layer+Math.floor(2*Math.random()), entities[numy].mask);
			}
		}

	  return;
	}

	AddScore(1);
	g_kills++;
	
	if (entities[numy].type == 12 && g_current_level == 17)
		explode = 1;

	if (entities[numy].type == 8)
	{
			//PlaySound(112, true);
		PlaySound(46,true);

		AddScore(1);

		AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor(y/GetTileHeight()),4, true);
		if (Math.random()<0.5)
			AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor((y)/GetTileHeight())+1,4);
//		AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor((y+1)/GetTileHeight()),4);

		SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "drone_arm", 0, gut_layer);	
		SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "drone_arm", 0, gut_layer+1);	

		if (entities[numy].hp2 > 0)
		{
			SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "drone_legs1", 0, gut_layer);	
			SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "drone_legs1", 0, gut_layer+1);	
			SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "drone_legs1", 0, gut_layer);	
		}
	
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 1);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 1);
	}
  else if (explode == 0)// && g_current_level < 16)
  {
		
		SpawnBlood(x,y, 6*Math.random()-3, -3-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -3-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
	
	  if (entities[numy].type > 0)
	  {
			if (entities[numy].type == 4)
			{
				PlaySound(56);
				return;
			}
			else if (entities[numy].type == 7)
				PlaySound(57,true);
			else if (entities[numy].type == 12)
				PlaySound(93,true);
			else if (entities[numy].type == 5)
				PlaySound(111, true);
			else //(for enemy 1 and 3 types
				PlaySound(43,true);
	  
			heads[numy].x = x;
			heads[numy].y = y;
			heads[numy].vx = vx;
			heads[numy].vy = vy;
			heads[numy].rotation = 0;
			heads[numy].frame = 0;
			heads[numy].active = true;
			heads[numy].stop = false;
			
			SetPersonIDHorizontalFlip(heads[numy].id1, (-1*entities[numy].dir+1)/2);

			
			if (entities[numy].type == 1)
				heads[numy].direction = "enemy1";
			else if (entities[numy].type == 3)
				heads[numy].direction = "enemy2";
			else if (entities[numy].type == 5)
				heads[numy].direction = "eye1";
			else if (entities[numy].type == 7)
				heads[numy].direction = "mantis";
			else if (entities[numy].type == 12)
				heads[numy].direction = "guard";
				
			SetPersonIDDirection(heads[numy].id1, heads[numy].direction);

			if (g_current_level == 9)
				SetPersonIDY(heads[numy].id1, heads[numy].y+2-8);
			else
				SetPersonIDY(heads[numy].id1, heads[numy].y+2);


			SetPersonIDX(heads[numy].id1, heads[numy].x);
			SetPersonIDAngle(heads[numy].id1, heads[numy].rotation);

			SetPersonIDLayer(heads[numy].id1, heads[numy].layer);



		}
	}
	else
	{
		if (entities[numy].type == 4);
		else if (entities[numy].type == 7)
			PlaySound(57,true);
		else
			PlaySound(46,true);
		AddScore(1);

		AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor(y/GetTileHeight()),4, true);
		if (Math.random()<0.5)
			AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor((y)/GetTileHeight())+1,4);
//		AddBackBlood(Math.floor(x/GetTileWidth()),Math.floor((y+1)/GetTileHeight()),4);

		SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "guts4", 0, gut_layer);	
		SpawnGuts(numy,x,y,6*Math.random()-3, -4-3*Math.random(), "guts4", 0, gut_layer+1);	
	
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 3);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 2);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 1);
		SpawnBlood(x,y, 6*Math.random()-3, -4-3*Math.random(), 1);
	}
}

















function AddBackBlood(x,y,amt, boo)
{
	if (x<1 || x>GetLayerWidth(back_blood_layer)-2
		||y<1 || y>GetLayerHeight(back_blood_layer)-2)
	{
		return;
	}
	
	var tileco = GetTile(x,y,0);
	var tileuo = GetTile(x,y-1,0);
	var tiledo = GetTile(x,y+1,0);
	var tilelo = GetTile(x-1,y,0);
	var tilero = GetTile(x+1,y,0);

	var tilec = GetTile(x,y, back_blood_layer);

	if (tileco == 4||tileco == 3)
		tileco = 0;
	if (tileuo == 4||tileuo == 3)
		tileuo = 0;
	if (tiledo == 4||tiledo == 3)
		tiledo = 0;
	if (tilelo == 4||tilelo == 3)
		tilelo = 0;
	if (tilero == 4||tilero == 3)
		tilero = 0;


	
	if (tileco!=0||amt == 0)
	  return;

	//will be a big amount;
	if (backblood[tilec]+amt >= 4)
	{
		if (tileco == 0)// && tilelo == 0&& tilero == 0&& tileuo == 0&& tiledo == 0)
		{
			if (GetTile(x,y-1,0) != 279 && GetTile(x,y+1,0)!= 279 && GetTile(x-1,y,0) != 279 && GetTile(x+1,y,0)!= 279)
			SetTile(x,y, back_blood_layer, 136);
			BackBloodFillIn(x,y);
			if (Math.random()<0.4 && boo == true)
			{
				if (GetTile(x,y, blood_layer) == 0)
					SetTile(x,y,blood_layer, 170+Math.floor(Math.random()*5));
			}
		}
		else if (tileco == 189)
		{
			BackBloodFillIn(x,y);
		}
	}
	else
	{
		if (tileco == 0)// && tilelo == 0&& tilero == 0&& tileuo == 0&& tiledo == 0)
		{
		  if (backblood[tilec]+amt == 1)
				SetTile(x,y, back_blood_layer, 129);
		  else if (backblood[tilec]+amt == 2)
				SetTile(x,y, back_blood_layer, 128);
		  else //if (backblood[tilec]+amt == 3)
		  {
		    if (Math.random() < 0.5)
					SetTile(x,y, back_blood_layer, 127);
				else
					SetTile(x,y, back_blood_layer, 126);
			}
		}
	}
}

function BackBloodFillIn(x,y)
{
	var carray = new Array(3);
	carray[0] = new Array(3);
	carray[1] = new Array(3);
	carray[2] = new Array(3);
	
	for (ci=0;ci<3;ci++)
		for (cj=0;cj<3;cj++)
			carray[ci][cj] = 0;
	
	if (x > 0)
	{
	  if (y > 0)
			carray[0][0] = GetTile(x-1,y-1,back_blood_layer);
		carray[0][1] = GetTile(x-1,y,back_blood_layer);
	  if (y < GetLayerHeight(back_blood_layer)-1)
			carray[0][2] = GetTile(x-1,y+1,back_blood_layer);
	}

  if (y > 0)
		carray[1][0] = GetTile(x,y-1,back_blood_layer);
	carray[1][1] = GetTile(x,y,back_blood_layer);
  if (y < GetLayerHeight(back_blood_layer)-1)
		carray[1][2] = GetTile(x,y+1,back_blood_layer);

	if (x < GetLayerWidth(back_blood_layer)-1)
	{
	  if (y > 0)
			carray[2][0] = GetTile(x+1,y-1,back_blood_layer);
		carray[2][1] = GetTile(x+1,y,back_blood_layer);
	  if (y < GetLayerHeight(back_blood_layer)-1)
			carray[2][2] = GetTile(x+1,y+1,back_blood_layer);
	}


	//start with the left tile, and proceed to bottom right
	for (ci=0;ci<3;ci++)
	{
		for (cj=0;cj<3;cj++)
		{
		  if (x-1+ci >= 0 && x-1+ci <= GetLayerWidth(back_blood_layer)-1 && y-1+cj >= 0 && y-1+cj <= GetLayerHeight(back_blood_layer)-1 && GetTile(x-1+ci, y-1+cj, back_blood_layer) != 279)
//			if (i!= 1 || j!=1)
				BackBloodFillIn2(x-1+ci,y-1+cj);
		}
	}
	
	for (ci=0;ci<3;ci++)
	{
		for (cj=0;cj<3;cj++)
		{
		  if (x-1+ci >= 0 && x-1+ci <= GetLayerWidth(back_blood_layer)-1 && y-1+cj >= 0 && y-1+cj <= GetLayerHeight(back_blood_layer)-1)
		  {
				if (GetTile(x-1+ci, y-1+cj, back_blood_layer) == 136 && carray[ci][cj] != 136)
					BackBloodFillIn(x-1+ci, y-1+cj);
			}
		}
	}

	
}

function BackBloodFillIn2(x,y)
{
	if (GetTile(x,y,back_blood_layer) == 136)
		return;

	//this is a no blood tile...
	if (GetTile(x,y,0) == 189 || GetTile(x,y,0) == 279)
		return;

	var barray = new Array(3);
	barray[0] = new Array(3);
	barray[1] = new Array(3);
	barray[2] = new Array(3);
	
	for (bi=0;bi<3;bi++)
		for (bj=0;bj<3;bj++)
			barray[bi][bj] = 0;
			
	if (x > 0)
	{
	  if (y > 0)
			barray[0][0] = GetTile(x-1,y-1,back_blood_layer);
		barray[0][1] = GetTile(x-1,y,back_blood_layer);
	  if (y < GetLayerHeight(back_blood_layer)-1)
			barray[0][2] = GetTile(x-1,y+1,back_blood_layer);
	}

  if (y > 0)
		barray[1][0] = GetTile(x,y-1,back_blood_layer);
	barray[1][1] = GetTile(x,y,back_blood_layer);
  if (y < GetLayerHeight(back_blood_layer)-1)
		barray[1][2] = GetTile(x,y+1,back_blood_layer);

  if (x < GetLayerWidth(back_blood_layer)-1)
  {
    if (y > 0)
			barray[2][0] = GetTile(x+1,y-1,back_blood_layer);
    barray[2][1] = GetTile(x+1,y,back_blood_layer);
    if (y < GetLayerHeight(blood_layer)-1)
			barray[2][2] = GetTile(x+1,y+1,back_blood_layer);
  }
 
  var boo=0;

  for (bi=0;bi<3;bi++)
  {
    for (bj=0;bj<3;bj++)
    {
      if (barray[bi][bj] == 136)
      {
				barray[bi][bj] = 1;
        boo++;
      }
			else
				barray[bi][bj] = 0;
    }
  }

  if (boo == 0) return;


	var tilec = GetTile(x,y,0);

	var tilel = 0;
	var tiler = 0;
	var tileu = 0;
	var tiled = 0;

	if (x > 0)
		tilel = GetTile(x-1,y,0);
	if (x < GetLayerWidth(blood_layer)-2)
		tiler = GetTile(x+1,y,0);

	if (y > 0)
		tileu = GetTile(x,y-1,0);
	if (y < GetLayerHeight(blood_layer)-2)
		tiled = GetTile(x,y+1,0);
		

	if (tilec == 4||tilec == 3)
		tilec = 0;
	if (tilel == 4||tilel == 3)
		tilel = 0;
	if (tiler == 4||tiler == 3)
		tiler = 0;
	if (tileu == 4||tileu == 3)
		tileu = 0;
	if (tiled == 4||tiled == 3)
		tiled = 0;


  //corners first
  if (barray[2][2] == 1 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 0 && barray[0][2] == 0 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 130);
		else if (x<GetLayerWidth(back_blood_layer)-2)
		{
			if (y < GetLayerHeight(blood_layer)-2)
			{
				if (tiled == 0 && tiler == 0)
					SetTile(x,y, back_blood_layer, 164);
				else if (tiler == 0)
					SetTile(x,y, back_blood_layer, 156);
			}
			else
				SetTile(x,y, back_blood_layer, 156);

		}
  }
  else if (barray[2][2] == 0 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 0 && barray[0][2] == 1 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 132);
		else if (x>0)
		{
			if (y < GetLayerHeight(blood_layer)-2)
			{
				if (tiled == 0 && tilel == 0)
					SetTile(x,y, back_blood_layer, 163);
				else if (tilel == 0)
					SetTile(x,y, back_blood_layer, 152);
			}
			else
				SetTile(x,y, back_blood_layer, 152);
		}
	}
  else if (barray[2][2] == 0 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 0 && barray[0][2] == 0 && barray[2][0] == 1)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 140);
		else if (y > 0)
		{
			if (tileu == 1)
				SetTile(x,y, back_blood_layer, 160);
			else
				SetTile(x,y, back_blood_layer, 148);
		}
		else
			SetTile(x,y, back_blood_layer, 148);
	}
  else if (barray[2][2] == 0 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 1 && barray[0][2] == 0 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 142);
		else if (y > 0)
		{
			if (tileu == 1)
				SetTile(x,y, back_blood_layer, 161);
			else
				SetTile(x,y, back_blood_layer, 147);
		}
		else
			SetTile(x,y, back_blood_layer, 147);
	}
  //sides
  else if (barray[2][1] == 0 && barray[1][2] == 1 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 0 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 131);
		else
		{
			if (x> 0)
			{
				//is a corner
				if (tilel == 0)
				{
					if (GetTile(x-1,y, back_blood_layer) != 136)
						SetTile(x,y, back_blood_layer, 163);
					else
						SetTile(x,y, back_blood_layer, 158);
				}
			}
			if (x<GetLayerWidth(blood_layer)-2)
			{
				//is a corner
				if (tiler == 0)
				{
					if (GetTile(x+1,y, back_blood_layer) != 136)
						SetTile(x,y, back_blood_layer, 164);
					else
						SetTile(x,y, back_blood_layer, 159);
				}
			}
		}
  }
  else if (barray[2][1] == 1 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 0 && barray[0][0] == 0 && barray[0][2] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 135);
		else if (y < GetLayerHeight(blood_layer)-2)
		{
			if (tiled != 0)
				SetTile(x,y, back_blood_layer, 155);
			else
				SetTile(x,y, back_blood_layer, 159);
		}
		else
			SetTile(x,y, back_blood_layer, 155);
	}
  else if (barray[2][2] == 0 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 1 && barray[1][0] == 0 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 137);
		else if (y < GetLayerHeight(blood_layer)-2)
		{
			if (tiled != 0)
				SetTile(x,y, back_blood_layer, 150);
			else
				SetTile(x,y, back_blood_layer, 158);
		}
		else
			SetTile(x,y, back_blood_layer, 150);




	}
  else if (barray[2][2] == 0 && barray[2][1] == 0 && barray[1][2] == 0 && barray[0][1] == 0 && barray[1][0] == 1 && barray[0][2] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 141);
		else 
			SetTile(x,y, back_blood_layer, 146);
	}
  //inner corners
  else if (barray[1][0] == 1 && barray[0][1] == 1 && barray[2][1] == 0 && barray[1][2] == 0 && barray[2][2] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 133);
		else 
			SetTile(x,y, back_blood_layer, 153);
	}
  else if (barray[1][0] == 1 && barray[0][1] == 0 && barray[2][1] == 1 && barray[1][2] == 0 && barray[0][2] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 134);
		else 
			SetTile(x,y, back_blood_layer, 154);
	}
  else if (barray[1][0] == 0 && barray[0][1] == 1 && barray[2][1] == 0 && barray[1][2] == 1 && barray[2][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 138);
		else 
			SetTile(x,y, back_blood_layer, 158);
	}
  else if (barray[1][0] == 0 && barray[0][1] == 0 && barray[2][1] == 1 && barray[1][2] == 1 && barray[0][0] == 0)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 139);
		else 
			SetTile(x,y, back_blood_layer, 159);
	}
  else if (barray[1][0] == 1 || barray[0][1] == 1 || barray[1][2] == 1 ||barray[2][1] == 1)
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 136);
  }
  else if ((barray[0][0] == 1 && barray[2][2] == 1) || (barray[2][0] == 1 && barray[0][2] == 1))
  {
    if (tilec == 0)
			SetTile(x,y, back_blood_layer, 136);
  }
}


var bdrip = 25;
var bd_timemax = 50;
var blood_drip = new Array(bdrip);
for (i=0;i<bdrip;i++)
{
	blood_drip[i] = new Object();
	blood_drip[i].x = blood_dx;
	blood_drip[i].y = 0;
	blood_drip[i].size = 3;
	blood_drip[i].amt = 3;
	blood_drip[i].timer = 4;
}

function UpdateDrips()
{
	for (di=0;di<bdrip;di++)
	{
		if (blood_drip[di].x > blood_dx && blood_drip[di].amt != 0)
		{
			blood_drip[di].timer--;
			if (blood_drip[di].timer <= 0)
			{
				if (blood_drip[di].amt == 2)
					blood_drip[di].timer = bd_timemax*3;
				else if (blood_drip[di].amt == 3)
					blood_drip[di].timer = bd_timemax*2;
				else
					blood_drip[di].timer = bd_timemax;
			  
				SpawnBlood(blood_drip[di].x,blood_drip[di].y,0,-1,blood_drip[di].size, "", 0)
			
				if (blood_drip[di].amt > 0)
					blood_drip[di].amt--;
				else if (blood_drip[di].amt == 0)
				  blood_drip[di].x = blood_dx;
			}

		}
	}
}

function SpawnDrip1(sdx,sdy,sdamt,sdsize)
{
	if (Math.random()<0.5)
	{
		for (ssdi = 0;ssdi<bdrip;ssdi++)
		{
			if (blood_drip[ssdi].x == blood_dx)
			{
				blood_drip[ssdi].x = sdx;
				blood_drip[ssdi].y = sdy;
				
				blood_drip[ssdi].timer = Math.floor(bd_timemax*3*Math.random());
				blood_drip[ssdi].amt = sdamt
				blood_drip[ssdi].size = sdsize;
				break;		
			}
		}
	}
}


function AddScore(amt)
{
	gore_score+=amt*gore_multi;
	
	if (gore_counter < gore_max)
	  gore_counter = gore_max;
	
	gore_level++;
	if (gore_level >= gore_next)
	{
	  gore_level = 0;
		gore_multi = Math.floor((gore_multi+1));
		if (gore_multi>99)
			gore_multi = 99;
		gore_next = 5+gore_multi;

	}
	
}